/** \file WO_Event.h
    Generic event.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_WO_EVENT
#define H_WO_EVENT

#include <DS_Queue.h>

#pragma comment(lib, "libWO.lib")

/** Generic Event.  Types are predefined, but
    parameters are totally dynamic. */
class Event : public Integral_Containable
{
public:
  /** Types of events available */
  typedef enum
  {
    Nothing=0,
    Collision=1,
    Generic=2
  } Type;

  /** Constructs an empty event with the specified type */
  Event(Type ET);

  /** Destroys an event */
  virtual ~Event();

  /** Add an argument to the event. */
  void addArg(Data Arg);

  /** Retrieve an argument (Containable*)
      throws IndexOutOfBounds */
  Data getArg(int Position);

  /** Needed for Integral_Containable */
  int  getValue() const;

  /** Returns the type of event. */
  Type getType() const;

protected:
  Type   m_ET;
  Vector m_Args;
};


/** This is a "container" for events.  Classes that must process events may 
    inherit from this class to implement this behavior.  
    Note: this is a Container::DESTRUCTIVE.
*/
class Event_Receiver {
public:
   Event_Receiver();
   virtual ~Event_Receiver() {}

   /** Accepts events and places them in a queue. */
   long handleEvent(Event* E);

   /** Checks the event queue for events to process */
   long hasMoreEvents();

   /** Returns an event to process, without removing it from the queue */
   Event* peekEvent();

   /** Removes the next event from the queue */
   void popEvent();

private:
   Queue m_Events;
};



#endif // H_WO_EVENT
