#ifndef H_PARTICLES
#define H_PARTICLES

#include <2D_Sprite.h>

class Particle 
{
public:
  Particle(Bitmap* BM);
  int render();
  int advance(float Fraction);
  void reset();
  float     m_Speed;
  fVector2D m_Position;
  fVector2D m_Velocity;
  float     m_Red;
  float     m_Green;
  float     m_Life;
  Bitmap   *m_Bitmap;
  TColor    m_Color;
};

typedef Particle* PParticle;

class ParticleSystem : public AnimatedSprite
{
public:
  ParticleSystem(int Width, int Height, int ParticlesNumber);
  ~ParticleSystem();
  virtual long advance(float Fraction);
  virtual long render(View& view);
  void reset();
protected:
  Bitmap*    m_Canvas;
  Sprite*    m_Sprite;
  int        m_ParticlesNumber;
  long       m_Status;
  Particle** m_Particles;
};

#endif // H_PARTICLES