/*
 * Decompiled with CFR 0.152.
 */
package karl.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class TriggerTimer
extends Timer {
    long _triggerTime = 0L;
    long _excludeTime = 0L;
    int _deadTime = 0;
    boolean _lazyStop = false;

    public TriggerTimer(int delay, ActionListener listener) {
        super(delay, null);
        super.addActionListener(new ConditionalActionListener(listener));
    }

    public synchronized void trigger() {
        long s = System.currentTimeMillis();
        this._triggerTime = s + (long)this.getDelay() + (long)this._deadTime;
        this._excludeTime = s + (long)this._deadTime;
    }

    public void addActionListener(ActionListener listener) {
        super.addActionListener(new ConditionalActionListener(listener));
    }

    public synchronized void deTrigger() {
        this._triggerTime = 0L;
        this._excludeTime = 0L;
    }

    public void stop() {
        this._lazyStop = true;
    }

    public void stopNow() {
        super.stop();
    }

    public boolean isTriggered() {
        long s = System.currentTimeMillis();
        return s >= this._excludeTime && s < this._triggerTime;
    }

    public void setDeadtime(int ms) {
        this._deadTime = ms;
    }

    class ConditionalActionListener
    implements ActionListener {
        ActionListener _child;

        public ConditionalActionListener(ActionListener listener) {
            this._child = listener;
        }

        public void actionPerformed(ActionEvent e) {
            if (TriggerTimer.this.isTriggered() && this._child != null) {
                this._child.actionPerformed(e);
            }
            if (TriggerTimer.this._lazyStop) {
                TriggerTimer.this.stopNow();
                TriggerTimer.this._lazyStop = false;
            }
        }
    }
}

