This is a modified version of the original manual page of Xearth. I have
left out many thinks that weren't relative with the current release.


Xearth understands the following command line options

 proj proj_type
Specify the projection type xearth should use. Supported
projection types are mercator and orthographic; these can
either be spelled out in full or abbreviated to merc or
orth, respectively. Xearth uses an orthographic projection
by default.


 pos pos_spec
Specify the position from which the Earth should be viewed. The
pos_spec (position specifier) consists of a keyword, possibly
followed by additional arguments. Valid keywords are: fixed,
sunrel, orbit, and random. (If you're having
problems getting xearth to accept a position specifier as a
command line argument, make sure and read the comments about position
specifier delimiters and using explicit quoting in the fifth paragraph
following this one.)

The position specifier keyword fixed should be followed by two
arguments, interpreted as numerical values indicating the latitude and
longitude (expressed in decimal degrees) of a viewing position that is
fixed with respect to the Earth's surface. Positive and negative
values of latitude correspond to positions north and south of the
equator, respectively. Positive and negative values of longitude
correspond to positions east and west of Greenwich, respectively.

The position specifier keyword sunrel should be followed by two
arguments, interpreted as numerical values indicating the offsets in
latitude and longitude (expressed in decimal degrees) of a viewing
position that is fixed with respect to the position of the
Sun. Positive and negative values of latitude and longitude are
interpreted as for the fixed keyword.

The position specifier keyword orbit should be followed by two
arguments, interpreted as numerical values indicating the period (in
hours) and orbital inclination (in decimal degrees) of a simple
circular orbit; the viewing position follows this orbit. Astute
readers will surely note that these parameters are not sufficient to
uniquely specify a single circular orbit. This problem is solved by
limiting the space of possible orbits to those positioned over 0
degrees latitude, 0 degrees longitude at time zero (the Un*x epoch,
see time(3)).

The position specifier keyword random should not be followed by
any arguments. When this keyword is used, the viewing position is
selected at random each time an update occurs.

Components of a position specifier are delimited by either whitespace,
forward slashes (/), or commas. Note that using whitespace to separate
position specifier components when invoking xearth from a shell
may require explicit quoting to ensure the entire position specifier
is passed as a single argument. For example, if you want to use spaces
to delimit components and are using a "typical" shell, you'd need to
use something like:


    -pos "fixed 42.33 -71.08"


or


    -pos 'fixed 42.33 -71.08'


to make things work. If you'd rather not have to explicitly quote
things, you can use forward slashes or commas instead of spaces to
separate components, as shown below.


    -pos fixed,42.33,-71.08
    -pos fixed/42.33/-71.08


If a position specifier is not provided, xearth uses a default
position specifier of "sunrel 0 0" (such that the entire day side of
the Earth is always visible).


 rot angle
Specify a rotated viewing position such that the north is not
"straight up" in the center of the rendered image. Positive values of
angle rotate the rendered image counterclockwise; negative
values rotate the rendered image clockwise. The default value of
angle is 0.


 sunpos sun_pos_spec
Specify a fixed point on the Earth's surface where the Sun is always
directly overhead. The sun_pos_spec (Sun position specifier)
consists of two components, both numerical values; these components
are interpreted as the latitude and longitude (in decimal degrees) of
the point where the Sun is directly overhead.

The details provided for position specifiers (see above) about the
interpretation of positive and negative latitude and longitude values
and the characters used to delimit specifier components apply to Sun
position specifiers as well.

By default, xearth calculates the actual position of the Sun and
updates this position with the progression of time.


 mag factor
Specify the magnification of the displayed image. When the
orthographic projection is in use, the diameter of the rendered Earth
image is factor times the shorter of the width and height of the
image (see the size option, below). For the mercator
projection, the width of the rendered image is factor times the
width of the image (see the size option, below). The default
magnification factor is 1.


 shade | noshade
Enable/disable shading. When shading is enabled, the surface of the
Earth is shaded according to the current position of the Sun (and the
values provided for the day, night, and term
options, below). When shading is disabled, use flat colors (green and
blue) to render land and water. Shading is enabled by default.


 label | nolabel
Enable/disable labeling. If labeling is enabled and xearth is
rendering into the X root window, provide a label that indicates the
current date and time and current viewing and sun positions. The
position of the label can be controlled using the labelpos
option (see below). Labeling is disabled by default.


 markers | nomarkers
Enable/disable markers. If markers are enabled and xearth is
rendering into the X root window, display small red circles and text
labels indicating the location of interesting places on the Earth's
surface. Markers are enabled by default.


 markerfile file
Specify a file from which user-defined marker data (locations and
names) should be read. Each line in the marker data file consists of
three required components: the latitude and longitude (expressed in
decimal degrees) followed by the text of the label that should be
used. Individual components are delimited by either whitespace,
forward slashes (/), or commas. Components that need to include
delimiter characters (e.g., a multi-word label) should be
enclosed in double quotes. For example, a line in a typical marker
data file might look something like:


    42.33 -71.08 "Boston, MA"    # USA


Everything between a `#' character and the end of a line, inclusive,
is a considered to be a comment. Blank lines and lines containing only
comments are allowed.

In addition to the three required components, xearth supports
optional following "key=value" components. In this version of
xearth, the only supported "key" is "align", which can be used
to control where marker labels are drawn in relation to the marker
proper. Supported alignment values are "left", "right", "above", and
"below"; the default behavior (if no alignment is specified) is
"align=right".

The marker data file is reread every time xearth redraws an
image into the X root window. In this way, the marker positions and
labels can be dynamic (e.g., given appropriate data sources,
markers could be used to encode hurricane positions, where earthquakes
have happened recently, temperatures at fixed locations, or other
forms of "real-time" data).

Xearth includes a built-in set of marker data for 76 major
locations around the world. The built-in data can be selected by
specifying "built-in" for the file argument; this is the default
behavior. The built-in set of marker data can be examined either by
using the showmarkers option (see below) or by reading the
BUILT-IN file included with the xearth source distribution (see
OBTAINING THE XEARTH SOURCE DISTRIBUTION, below).


 showmarkers
This option indicates that xearth should load the marker data
(whether built-in or user-specified), print a copy of it to standard
out in a form suitable for use with the markers option (see
above), and then exit.


 stars | nostars
Enable/disable stars. If stars are enabled, the black background of
"space" is filled with a random pattern of "stars" (individual white
pixels). The fraction of background pixels that are turned into stars
can be controlled with the starfreq option (see below). Stars
are enabled by default.


 starfreq frequency
Set the density of the random star pattern (see stars, above);
frequency indicates the fraction of background pixels that
should be turned into "stars". The default value of frequency is
0.002.


 bigstars percent
Set the percentage of double-width stars (see stars, above);
by default, all stars are a single pixel, but this option can be used
to create some stars that are composed of two horizontal pixels.  This 
provides a slightly less uniform look to the "night sky".


 grid | nogrid
Enable/disable the display of a longitude/latitude grid on the Earth's
surface. The spacing of major grid lines and dots between major grid
lines can be controlled with the grid1 and grid2
options (see below). Grid display is disabled by default.


 grid1 grid1
Specify the spacing of major grid lines if grid display (see
grid, above) is enabled; major grid lines are drawn with a
90/grid1 degree spacing. The default value for grid1 is 6,
corresponding to 15 degrees between major grid lines.


 grid2 grid2
Specify the spacing of dots along major grid lines if grid display
(see grid, above) is enabled. Along the equator and lines of
longitude, grid dots are drawn with a 90/(grid1 x grid2)
degree spacing. The spacing of grid dots along parallels (lines of
latitude) other than the equator is adjusted to keep the surface
distance between grid dots approximately constant. The default value
for grid2 is 15; combined with the default grid1 value of
6, this corresponds to placing grid dots on a one degree spacing.


 day pct
Specify the brightness that should be used to shade the day side of
the Earth when shading is enabled. Pct should be an integer
between 0 and 100, inclusive, where 0 indicates total darkness and 100
indicates total illumination. This value defaults to 100.


 night pct
Specify the brightness that should be used to shade the night side of
the Earth when shading is enabled. Pct should be an integer
between 0 and 100, inclusive, where 0 indicates total darkness and 100
indicates total illumination. This value defaults to 5 (if this seems
overly dark, you may want to double-check that appropriate gamma
correction is being employed; see gamma, below).


 term pct
Specify the shading discontinuity at the terminator (day/night
line). Pct should be an integer between 0 and 100, inclusive. A
value of x indicates that the shading should immediately jump
x percent of the difference between day and night shading values
(see day and night, above) when crossing from the
night side to the day side of the terminator. Thus a value of 0
indicates no discontinuity (the original xearth behavior), and a
value of 100 yields a maximal discontinuity (such that the entire day
side of the earth is shaded with the day shading value). This
value defaults to 1.


 timewarp timewarp_factor
Scale the apparent rate at which time progresses by
timewarp_factor. The default value of timewarp_factor is
1.0.


 time fixed_time
Instead of using the current time to determine the "value" of
time-dependent positions (e.g., the position the sun), use a
particular fixed_time (expressed in seconds since the Un*x epoch
(see time(3)).


OBTAINING THE XEARTH SOURCE DISTRIBUTION
The latest-and-greatest version of xearth should always be available
via a link from the xearth WWW home page (URL
http://cag-www.lcs.mit.edu/~tuna/xearth/index.html), or, for the
web-deprived, via anonymous ftp from cag.lcs.mit.edu in /pub/tuna.

NOTES
There are a number of improvements that I'd love to make to
xearth, but I really should be working on my thesis instead of
hacking on this.

The map information used in
 xearth
was derived from the "CIA World Data Bank II map database," as taken
from some "cbd" files that were apparently originally generated by
Brian Reid at DEC WRL.

The Graphics Interchange Format(c) is the Copyright property of
CompuServe Incorporated. GIF(sm) is a Service Mark property of
CompuServe Incorporated.

Thanks to Robert Berger for allowing me to include his nifty gamma
measurement image and associated text in the xearth source
distribution.

Thanks to Jamie Zawinski for suggesting that I look at his
xscreensaver package for a good example of how to use the resource and
command line option parts of Xt; his code saved me piles of lossage.

Thanks to Chris Metcalf for the -bigstars stuff, a pile of general
source code cleaning, and spell checking everything carefully.

Thanks to Chris Hayward, Chris Metcalf, Sherman Mui, Dan Rich, and
Leonard Zubkoff for giving the pre-release of version 1.0 a test
drive.

Kudos to Jef Poskanzer for his excellent PBMPLUS toolkit. 

Finally, thanks to everybody that sent encouragement, suggestions, and
patches. Apologies to the many people whose good ideas didn't make it
into this release.

COPYRIGHT
Copyright (C) 1989, 1990, 1993, 1994, 1995 by Kirk Lauritz Johnson

Portions of the xearth source code, as marked, are:


  Copyright (C) 1989, 1990, 1991 by Jim Frost
  Copyright (C) 1992 by Jamie Zawinski <jwz@lucid.com>


Permission to use, copy, modify and freely distribute xearth for
non-commercial and not-for-profit purposes is hereby granted without
fee, provided that both the above copyright notice and this permission
notice appear in all copies and in supporting documentation.

Unisys Corporation holds worldwide patent rights on the Lempel Zev
Welch (LZW) compression technique employed in the CompuServe GIF image
file format as well as in other formats. Unisys has made it clear,
however, that it does not require licensing or fees to be paid for
freely distributed, non-commercial applications (such as xearth) that
employ LZW/GIF technology. Those wishing further information about
licensing the LZW patent should contact Unisys directly at
(lzw_info@unisys.com) or by writing to


  Unisys Corporation
  Welch Licensing Department
  M/S-C1SW19
  P.O. Box 500
  Blue Bell, PA 19424


The author makes no representations about the suitability of this
software for any purpose. It is provided "as is" without express or
implied warranty.

THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

 AUTHOR

  Kirk Johnson <tuna@cag.lcs.mit.edu>
  MIT Laboratory for Computer Science


Patches, bug reports, and suggestions are welcome, but I can't
guarantee that I'll get around to doing anything about them in a
timely fashion.
