/* graf-add.c - bulletin board graffiti program      */
/*          a real mess, patrick@sideways.gen.nz */

#include <stdio.h>
#include <string.h>

main(int argc,char *argv[])
{
FILE *graf;
int key,st;
char words[128];

if (argc!=2) {
  printf("Syntax: graf-add <graffiti file>\n");
  printf("  eg. graf-add E:\\WAFFLE\\WORDS\\VG\n\n");
  printf("Presumes current directory is one containing temp. file 'graffiti'\n");
  exitgraf();
}

/* if file empty, exit */
graf=fopen("graffiti","r");
st=getc(graf);
fclose(graf);
if (st==EOF) {
  printf("Entry cancelled\n");
  exitgraf();
}

printf("\n\nGraffiti Menu\n");
printf("-------------\n");
do {
  printf("\n List  Save  Quit? ");
  key=getch();
  if (key==3 || key==27)
    printf("%cUse (Q)uit if you wish to cancel this entry\n\n",13);
  else
    if (key>='a' && key<='z') key-=32;  /* lower into UPPER */
  else
    if (key<32 || key>126) {
      printf(" huh?\n\n");
      key='?';
    }
  if (key>='A' && key<='Z') printf("%c",key);
  if (key=='L') {
    printf("ist\n");
    printf("     graffiti entered   (^C to cancel)\n");
    system("type graffiti");
    printf(" --- end of text.\n");
  }
} while ((key!='S') && (key!='Q'));

if (key=='S') {
  printf("aving ..\n  [inserting");

  words[0]=0;
  strcpy(words,"type ");
  strcat(words,argv[1]);
  strcat(words,">>graffiti");
  system(words);         /* type /waffle/words/vg >> graffiti */
                         /* append Graffiti file onto graf. file entered */

  printf(", purging");
  unlink(argv[1]);              /* delete /waffle/words/vg */
  rename("graffiti",argv[1]);   /* rename graffiti /waffle/words/vg */
  printf(", saved!]\n");
}
if (key=='Q') {
  printf("uit\n  Entry cancelled\n");
}
exitgraf();
}

exitgraf()
/* delete file Graffiti, then exit */
{
unlink("graffiti");
exit(0);
}
