;   _______________________________________________________________
;  |                                                               |
;  |            Copyright (C) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  Program Title : Fastfile.Asm                                 |    | ___
;  |  Author        : Steven Lutrov                                |    |    |
;  |  Revision      : 2.01                                         |    |    |
;  |  Date          : 1990-03-16                                   |    |    |
;  |  Language      : Turbo Assembler                              |    |    |
;  |                                                               |    |    |
;  |                                                               |    |    |
;  |  Description   : Assembly functions For primitive file        |    |    |
;  |                : handeling.                                   |    |    |
;  |                : Tested on Turbo Pascal Turbo Pascal 5.5      |    |    |
;  |                                                               |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;



Code Segment Word Public

Assume Cs:Code,Ds:Data


Public Closefile,Createfile,Erasefile,Fmovepointer,Openfile,Readfile,
Public Writefile,Getverify,Getvolume,Readsector,Setverify,Setvolume
Public Writesector



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Getverify: Boolean;
;
;
Getverify Proc Far
        Mov  Ah,54H                     ;Dos Func To Get Verify
        Int  21H                        ;Get Status
        Ret
Getverify Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Getvolume(Disk: Integer; Workarea: Pointer): Stype;
;
;
Getvolume Proc Far
                Push Bp                         ;Save Turbos Bp
                Mov  Bp,Sp                      ;
                Push Ds                         ;Save Turbo'S Ds
                Mov  Ah,2Fh                     ;Save Current Dta
                Int  21H                        ;
                Push Es                         ;
                Push Bx                         ;
                Cld                             ;Set Direction Flag
                Lds  Dx,Dword Ptr[Bp+6]         ;Ds:Dx Pts To Workarea
                Mov  Ah,1Ah                     ;Function To Set Dta
                Int  21H                        ;Set Dta
                Mov  Si,Dx                      ;Point Si To Dta
                Mov  Al,[Bp+10]                 ;Get Drive Specifier
                Or   Al,Al                      ;0 = Current Drive
                Jnz  Getv1                      ;Jump If Not Current
                Mov  Ah,19H                     ;Dos Func To Get Drv Num
                Int  21H                        ;Get Current Drive
                Inc  Al                         ;Count Drives From 1
Getv1:          Add  Al,64                      ;Convert To A:, B: Etc.
                Mov  [Si],Al                    ;Write It
                Inc  Si                         ;Forward Ptr
                Mov  Al,':'                     ;Colour To Follow Drv Spec
                Mov  [Si],Al                    ;Write It
                Inc  Si                         ;Forward Ptr
                Mov  Al,'*'                     ;Global Character
                Mov  [Si],Al                    ;Write It
                Inc  Si                         ;Forward Ptr
                Mov  Al,'.'                     ;Global Character
                Mov  [Si],Al                    ;Write It
                Inc  Si                         ;Forward Ptr
                Mov  Al,'*'                     ;Global Character
                Mov  [Si],Al                    ;Write It
                Inc  Si                         ;Forward Ptr
                Mov  Al,0                       ;Terminate With 0
                Mov  [Si],Al                    ;Write It
                Mov  Cx,8                       ;Attribute For Vol Label
                Les  Di,Dword Ptr[Bp+12]        ;Point To Return String
                Mov  Ah,4Eh                     ;Function To Seek File
                Int  21H                        ;Seek Vol Label
                Jnc  Getv2                      ;Jump If Found
                Mov  Byte Ptr Es:[Di],0         ;Set Null String Descriptor
                Jmp  Getv5                      ;Go Quit
Getv2:          Inc  Di                         ;Forward Pointer To First Char
                Mov  Si,Dx                      ;Si To Start Of Workarea
                Add  Si,30                      ;Offset To Vol Label
                Sub  Cl,Cl                      ;Count Strx Len In Cl
Getv3:          Lodsb                           ;Get A Byte
                Or   Al,Al                      ;Test For Terminating 0
                Jz   Getv4                      ;Jump When Finished
                Cmp  Al,'.'                     ;Period?
                Je   Getv3                      ;Skip It If So
                Stosb                           ;Transfer Char
                Inc  Cl                         ;Inc Length Counter
                Jmp  Short Getv3                ;Go Get Next
Getv4:          Les  Di,Dword Ptr[Bp+12]        ;Return String Address
                Mov  Es:[Di],Cl                 ;Set Descriptor
Getv5:          Pop  Dx                         ;Restore Prior Dta
                Pop  Ds                         ;
                Mov  Ah,1Ah                     ;
                Int  21H                        ;
                Pop  Ds                         ;
                Pop  Bp
                Ret  6
Getvolume  Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Readsector(Segment,Offset,Drive,Sector,Number: Word);
;
;
Data    Segment
        Extrn  Errreturn:Byte
Data    Ends
;
;
Readsector Proc Far
                Push  Bp                        ;Save Bp
                Mov   Bp,Sp                     ;Set Up Stack Frame
                Push  Ds                        ;Save Ds
                Lds   Bx,Dword Ptr[Bp+12]       ;Get Buffer Address
                Mov   Al,[Bp+10]                ;Drive Code
                Dec   Al                        ;Adjust For Turbo
                Mov   Dx,[Bp+8]                 ;Logical Sector Number
                Mov   Cx,[Bp+6]                 ;Number Sectors To Read
                Int   25H                       ;Read The Sector(S)
                Mov   Bl,0                      ;0 = No Error
                Jnc   Rsec1                     ;Test For Error
                Mov   Bl,Ah                     ;Error Code To Bl
Rsec1:          Pop   Cx                        ;Balance Stack
                Pop   Ds                        ;Restore Ds
                Pop   Bp                        ;Restore Bp
                Mov   Errreturn,Bl              ;Set Error Code
                Ret   10
Readsector Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Setverify(Setting: Boolean);
;
;
Setverify Proc Far
                Mov  Bx,Sp                      ;
                Sub  Dl,Dl                      ;Dl Must = 0
                Mov  Al,Ss:[Bx+4]               ;1 = On, 0 = Off
                Mov  Ah,2Eh                     ;Dos Func To Set Verify
                Int  21H                        ;Set Verification
                Ret  2
Setverify Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Setvolume(Disk: Integer; Newlabel: Stype; Workarea: Pointer);
;
;
Setvolume Proc Far
                Push Bp                         ;
                Mov  Bp,Sp                      ;
                Push Ds                         ;
                Mov  Ah,2Fh                     ;Save Current Dta
                Int  21H                        ;Dos Interrupt
                Push Es                         ;
                Push Bx                         ;
                Lds  Dx,Dword Ptr[Bp+6]         ;Ds:Dx Pts To Workarea
                Mov  Ah,1Ah                     ;Function To Set Dta
                Int  21H                        ;Set Dta
Setv1:          Les  Di,Dword Ptr[Bp+6]         ;Es:Di Pts To Workarea
                Lds  Si,Dword Ptr[Bp+6]         ;Ds:Dx Pts To Workarea
                Mov  Ax,2020H                   ;Clear With Spaces
                Mov  Cx,22                      ;22 Words In Workarea
                Cld                             ;Direction Forward
                Rep  Stosw                      ;Clear The Workarea
                Mov  Byte Ptr[Si],0Ffh          ;Ff Marks Extended Fcb
                Add  Si,6                       ;Forward To Attri Byte
                Mov  Byte Ptr[Si],8             ;Volume Label Attribute
                Inc  Si                         ;Forward Ptr
                Mov  Al,[Bp+14]                 ;Drive Number
                Mov  [Si],Al                    ;Set It
                Mov  Bx,Si                      ;
                Inc  Bx                         ;
                Les  Di,Dword Ptr[Bp+10]        ;Es:Di Pts To New Label
                Sub  Cx,Cx                      ;Clear Cx
                Mov  Cl,Es:[Di]                 ;Length Of New Label
                Jcxz Sevol3                     ;Jump If Null
                Cmp  Cx,13                      ;In Range?
                Ja   Sevol4                     ;Quit If Not
Sevol2:         Inc  Si                         ;Forward Target Ptr
                Inc  Di                         ;
                Mov  Al,Es:[Di]                 ;Get A Byte
                Mov  [Si],Al                    ;Transfer To Workarea
                Loop Sevol2                     ;Go Do Next
                Mov  Ah,16H                     ;"Create File"
                Int  21H                        ;Go Set Label
                Cmp  Al,0Ffh                    ;Test For Error
                Jne  Sevol4                     ;Quit If None
Sevol3:         Mov  Ax,Ds                      ;Point Es:Di Back To Label Field
                Mov  Es,Ax                      ;
                Mov  Di,Bx                      ;
                Mov  Al,'?'                     ;Write Global Chars
                Mov  Cx,13                      ;13 Chars
                Rep  Stosb                      ;Write Them
                Mov  Ah,13H                     ;Func To Delete Label
                Int  21H                        ;Get Rid Of Old Label
                Cmp  Al,0Ffh                    ;Test For Error
                Je   Sevol4                     ;Get Out If Error
                Mov  Si,Bx                      ;Pt Back To Label Field
                Mov  Di,Bx                      ;Di Too
                Jmp  Short Setv1                ;Go Set Up Label Again
Sevol4:         Pop  Dx                         ;Restore Prior Dta
                Pop  Ds                         ;
                Mov  Ah,1Ah                     ;
                Int  21H                        ;
                Pop  Ds                         ;
                Pop  Bp                         ;
                Ret  10
Setvolume  Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Writesector(Segment,Offset,Drive,Sector,Number: Word;);
;
;
Data    Segment
        Extrn  Errreturn:Byte
Data    Ends
;
;
Writesector Proc Far
                Push  Bp                        ;Save Bp
                Mov   Bp,Sp                     ;Set Up Stack Frame
                Push  Ds                        ;Save Ds
                Lds   Bx,Dword Ptr[Bp+12]       ;Get Buffer Address
                Mov   Al,[Bp+10]                ;Drive Code
                Dec   Al                        ;Adjust For Turbo
                Mov   Dx,[Bp+8]                 ;Logical Sector Number
                Mov   Cx,[Bp+6]                 ;Number Sectors To Write
                Int   26H                       ;Write The Sector(S)
                Mov   Bl,0                      ;0 = No Error
                Jnc   Wsec1                     ;Test For Error
                Mov   Bl,Ah                     ;Error Code To Bl
Wsec1:          Pop   Cx                        ;Balance Stack
                Pop   Ds                        ;Restore Ds
                Pop   Bp                        ;Restore Bp
                Mov   Errreturn,Bl              ;Set Error Code
                Ret   10                        ;
Writesector Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Createfile(Fname:String; Attribute:Integer):Integer;

Fcname     Equ        Dword Ptr [Bp+8]
Fcattr     Equ        Word  Ptr [Bp+6]
Fcsize     Equ        4 + 2

Createfile    Proc Far
                Push Bp                      ; Save Bp
                Mov  Bp,Sp                   ; Setup Stack Frame
                Push Ds                      ; Save Ds
                Lds  Si,Fcname               ; Get Fcname Address
                Mov  Bl,[Si]                 ; Get Length Of String In Dx
                Inc  Si                      ; Skip Pascal String[0] Length Byte
                Xor  Bh,Bh                   ; Bx=$00Xx, Where Xx Is Length
                Mov  [Si+Bx],Bh              ; End String With Asciz
                Mov  Dx,Si                   ; Fname Asciz Ptr In Ds:Dx
                Mov  Cx,Fcattr               ; Attribute To Set In Created File
                Mov  Ah,3Ch                  ; Create
                Int  21H                     ; Do It
                Jnc  Fc01                    ; Jump If No Error
                Neg  Ax                      ; Ax:=-Ax
Fc01:           Pop  Ds                      ;
                Pop  Bp                      ;
                Ret  Fcsize
Createfile    Endp
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Openfile(Name:String; Access:Integer):Integer;

Foname     Equ        Dword Ptr [Bp+8]
Foacce     Equ        Word  Ptr [Bp+6]
Fosize     Equ        4 + 2

Openfile      Proc Far
                Push Bp                      ; Save Bp
                Mov  Bp,Sp                   ; Set Up Stack Frame
                Push Ds                      ; Save Ds
                Lds  Si,Foname               ; Get Foname Address
                Mov  Bl,[Si]                 ; Get Length Of String In Dx
                Inc  Si                      ; Skip Pascal String[0] Length Byte
                Xor  Bh,Bh                   ; Bx=$00Xx, Where Xx Is Length
                Mov  [Si+Bx],Bh              ; End String With Asciz
                Mov  Dx,Si                   ; Fname Asciz Ptr In Ds:Dx
                Mov  Ax,Foacce               ; File Access Code
                Mov  Ah,3Dh                  ; Open File
                Int  21H                     ; Do It
                Mov  Bx,0                    ; Boolean False
                Jnc  Fo01                    ; Jump If No Error
                Neg  Ax                      ; Ax:=-Ax;
Fo01:           Pop  Ds                      ; Restore Ds
                Pop  Bp                      ; Restore Bp
                Ret  Fosize
Openfile      Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Closefile(Handle:Integer):Boolean;

Fclhandle  Equ  Word Ptr [Bp+6]
Fclsize    Equ  2

Closefile     Proc Far
                Push Bp                      ; Save Bp Stack
                Mov  Bp,Sp                   ; Set Up Stack Frame
                Mov  Bx,Fclhandle            ; File Handler Identifier
                Mov  Ah,3Eh                  ; Close
                Int  21H                     ; Do It
                Mov  Ax,0                    ; Boolean False
                Jc   Fcl01                   ; Jump If Error
                Mov  Ax,1                    ; Boolean True
Fcl01:          Pop  Bp
                Ret  Fclsize
Closefile     Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Writefile(Handle:Integer; Nwrite:Word; Var Buff):Integer;

Fwhandle   Equ  Word Ptr [Bp+12]
Fwwrite    Equ  Word Ptr [Bp+10]
Fwbuff     Equ  Dword Ptr [Bp+6]
Fwsize     Equ  2 + 2 + 4

Writefile     Proc Far
                Push Bp                      ; Save Bp Stack
                Mov  Bp,Sp                   ; Set Up Stack Frame
                Push Ds                      ; Save Ds
                Mov  Bx,Fwhandle             ; File Handler Identifier
                Lds  Dx,Fwbuff               ; Data Buffer
                Mov  Cx,Fwwrite              ; Number Of Bytes To Write
                Cmp  Cx,07Fffh               ; Above 7Fff
                Ja   Fw02                    ; To Many Bytes To Write
                Mov  Ah,40H                  ; Write
                Int  21H                     ; Do It
                Jnc  Fw01                    ; Jump If No Error
Fw02:           Neg  Ax                      ; Ax:=-Ax;
Fw01:           Pop  Ds                      ; Restore Bs
                Pop  Bp                      ; Restore Bp
                Ret  Fwsize
Writefile     Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Readfile(Handle:Word; Amount:Word; Var Buff):Integer;

Frhandle   Equ  Word Ptr [Bp+12]
Framount   Equ  Word Ptr [Bp+10]
Frbuff     Equ  Dword Ptr [Bp+6]
Frsize     Equ  2 + 2 + 4

Readfile      Proc Far
                Push Bp                      ; Store Bp
                Mov  Bp,Sp                   ; Setup Stack Frame
                Push Ds                      ; Save Ds
                Mov  Bx,Frhandle             ; File Handler Identifier
                Lds  Dx,Frbuff               ; Data Buffer
                Mov  Cx,Framount               ; Number Of Bytes To Read
                Cmp  Cx,07Fffh               ; Above 7Fff
                Ja   Fr02                    ; Too Many Bytes To Read
                Mov  Ah,3Fh                  ; Read
                Int  21H                     ; Do It
                Jnc  Fr01                    ; Jump If No Error
Fr02:           Neg  Ax                      ; Make Ax Negative
Fr01:           Pop  Ds                      ; Restore Ds
                Pop  Bp                      ; Restore Bp
                Ret  Frsize
Readfile      Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Fmovepointer(Handle:Integer; Mode:Integer; Offset:Longint;
;                      Var Location:Longint):Boolean;

Fshandle   Equ  Word Ptr [Bp+16]
Fsmode     Equ  Word Ptr [Bp+14]
Fsofshi    Equ  Word Ptr [Bp+12]
Fsofslo    Equ  Word Ptr [Bp+10]
Fslocation Equ  Dword Ptr [Bp+6]

Fssize     Equ  2 + 2 + 4 + 4

Fmovepointer      Proc Far
                Push Bp                      ; Save Bp
                Mov  Bp,Sp                   ; Set Up Stack Frame
                Push Ds                      ; Save Ds
                Mov  Bx,Fshandle             ; File Handler Identifier
                Mov  Cx,Fsofshi              ; File Offset In Cx
                Mov  Dx,Fsofslo              ; File Offset In Cx:Dx
                Mov  Ax,Fsmode               ; Load Method Code
                Mov  Ah,42H                  ; Seek
                Int  21H                     ; Do It
                Mov  Bx,1                    ; Boolean True
                Jnc  Fs01                    ; Jump If Not Error
                Mov  Bx,0                    ; Boolean False
                Mov  Dx,0                    ; High Word In Location=$0000
Fs01:           Les  Di,Fslocation           ; Point To Fslocation
                Cld                          ; Set Direction Flag
                Stosw                        ; Low Word To Location
                Mov  Ax,Dx                   ;
                Stosw                        ; High Word To Location
                Mov  Ax,Bx                   ; Return False Or True
                Pop  Ds                      ; Restore Ds
                Pop  Bp                      ; Restore Bp
                Ret  Fssize
Fmovepointer      Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Erasefile(Name:String):Integer;

Fename     Equ  Dword Ptr [Bp+6]
Fesize     Equ  4

Erasefile     Proc Far
                Push Bp                      ; Save Bp
                Mov  Bp,Sp                   ; Set Up Stack Frame
                Push Ds                      ; Save Ds
                Lds  Si,Fename               ; Get Address Of Fename
                Mov  Bl,[Si]                 ; Get Length Of String In Dx
                Inc  Si                      ; Skip Pascal String[0] Length Byte
                Xor  Bh,Bh                   ; Bx=$00Xx, Where Xx Is Length
                Mov  [Si+Bx],Bh              ; End String With Asciz
                Mov  Dx,Si                   ; Fname Asciz Ptr In Ds:Dx
                Mov  Ah,41H                  ; Erase File
                Int  21H                     ; Do It
                Mov  Bx,0                    ; Boolean False
                Jnc  Fe01                    ; Jump If No Error
                Neg  Ax                      ; Make Ax -Ax;
                Jmp  Fe02                    ; Restore And Exit
Fe01:           Mov  Ax,0                    ;
Fe02:           Pop  Ds                      ; Restore Ds
                Pop  Bp                      ; Restore Bp
                Ret  Fesize
Erasefile     Endp


Code    Ends
        End

