#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <dos.h>
#include <mem.h>

#include "vesa_vid.h"

ModeInfoBlock _modeInfo;
SVGAInfoBlock _svgaInfo;
void (far * BankFunc)();

extern int bankAdjust;
extern int bytesPerLine;
extern int charHeight;


int initSuperVGA(void)
{
   return getSVGAInfo(&_svgaInfo);
}

int setSuperVGAMode(int mode)
/****************************************************************************
*
* Function:     setSuperVGAMode
* Parameters:   mode    - SuperVGA mode to set
* Returns:      0 if successful
*               1 if no VESA support
*               2 if invalid VESA signature
*               3 if invalid mode
*
* Description:  Sets up the specified video mode, and obtains the correct
*               dimensions and bytesPerLine values for the mode.
*
****************************************************************************/
{
   union REGS      regs;

   if(getModeInfo(mode,&_modeInfo)!=0)
      return 3;

   regs.x.ax = 0x4F02;             /* Set the mode */
   regs.x.bx = mode;
   int86(0x10,&regs,&regs);
   if(regs.x.ax != 0x004F)
      return 4;

   BankFunc=_modeInfo.WinFuncPtr;
   bytesPerLine = _modeInfo.BytesPerScanLine;
   bankAdjust = 64 / _modeInfo.WinGranularity;
   charHeight = _modeInfo.YCharSize;

   return 0;
}

int _oldMode,_stateSize;
void *_videoState;

int state_saved=0;

void SaveState(void)
{
   union REGS  regs;
   struct SREGS    sregs;

   regs.x.ax = 0x4F04;             /* Get size of video state buffer   */
   regs.x.dx = 0x0000;
   regs.x.cx = 0x000F;
   int86(0x10,&regs,&regs);
   if(regs.x.ax != 0x004F)
   {
      puts("VESA function 0x04 (get video state buffer size) failed");
      _stateSize=256;             /* Use the default */
   }
   else
   {
      _stateSize = regs.x.bx * 64;
   }

   if ((_videoState = malloc(_stateSize)) == NULL)
   {
      puts("Out of memory attempting to save the video state");
      state_saved=0;
      return;
   }
   regs.x.ax = 0x4F04;             /* Save current video state         */
   regs.x.dx = 0x0001;
   regs.x.cx = 0x000F;
   regs.x.bx = FP_OFF(_videoState);
   sregs.es = FP_SEG(_videoState);
   int86x(0x10,&regs,&regs,&sregs);
   if(regs.x.ax != 0x004F)
   {
      puts("VESA function 0x04 (save current video state) failed");
      state_saved=0;
      return;
   }

   regs.x.ax = 0x4F03;             /* Save the previous video mode     */
   int86(0x10,&regs,&regs);
   if(regs.x.ax != 0x004F)
   {
      puts("VESA function 0x03 (save current video mode) failed");
      state_saved=0;
      return;
   }
   _oldMode = regs.x.bx;
   state_saved=1;
}

void RestoreState(void)
{
   if(state_saved)
   {
      union REGS regs;
      struct SREGS sregs;

      regs.x.ax = 0x4F04;             /* Restore previous video state     */
      regs.x.dx = 0x0002;
      regs.x.cx = 0x000F;
      regs.x.bx = FP_OFF(_videoState);
      sregs.es = FP_SEG(_videoState);
      int86x(0x10,&regs,&regs,&sregs);
      if(regs.x.ax != 0x004F)
      {
         puts("VESA function 0x04 (restore video state) failed");
         exit(1);
      }

      regs.x.ax = 0x4F02;             /* Restore old video mode           */
      regs.x.bx = _oldMode;
      int86(0x10,&regs,&regs);
      if(regs.x.ax != 0x004F)
      {
         puts("VESA function 0x02 (restore video mode) failed");
         exit(1);
      }
   }
   else
   {
      setSuperVGAMode(0x03);
   }
}
