#include "specgram.h"
#include "display.h"

int _font_color;
int _font_width;
int _font_height;
int _draw_colors;

void draw_init(void)
{
   DOUT("draw_init");
}

void draw_setup_graphics(void)
{
   int textd;

   SRGP_begin("Spectrogram",800,600,8,FALSE);
   _draw_colors=1<<(SRGP_inquireCanvasDepth()-1);
   if(_draw_colors<32)
   {
      printf("Hey, I need more than %d colors!\n",_draw_colors);
      exit(1);
   }
   SRGP_setBackgroundColor(0);
   SRGP_setFont(0);
   SRGP_inquireTextExtent("H", &_font_width, &_font_height, &textd);
   SRGP_setFillStyle(SOLID);
   SRGP_setLineStyle(CONTINUOUS);
   SRGP_setLineWidth(1);
   SRGP_setKeyboardProcessingMode(RAW);
   SRGP_setInputMode(KEYBOARD,EVENT);
}


void draw_cleanup_graphics(void)
{
   SRGP_end();
}

void draw_cleardisplay(void)
{
   SRGP_setColor(0);
   SRGP_fillRectangleCoord(0,0,799,599);
}

void draw_fontcolor(int c)
{
   _font_color=c;
}

void draw_text_left(int x,int y,char *string)
{
   SRGP_setColor(_font_color);
   SRGP_text(SRGP_defPoint(x,600-_font_height-y),string);
}

void draw_text_centered(int x,int y,char *string)
{
   SRGP_setColor(_font_color);
   SRGP_text(SRGP_defPoint(x-strlen(string)*_font_width/2,600-_font_height-y),string);
}

void draw_text_right(int x,int y,char *string)
{
   SRGP_setColor(_font_color);
   SRGP_text(SRGP_defPoint(x-strlen(string)*_font_width,600-_font_height-y),string);
}

void draw_text_vertical(int x,int y,char *string)
{
   char buf[2];
   buf[1]=0;
   SRGP_setColor(_font_color);
   while(*string)
   {
      buf[0]=*string;
      SRGP_text(SRGP_defPoint(x,600-_font_height-y),buf);
      y+=_font_height;
      string++;
   }
}

void draw_rectangle(int x1,int y1,int x2,int y2,int c)
{
   SRGP_setColor(c);
   SRGP_rectangleCoord(x1,599-y2,x2,599-y1);
}

void draw_line(int x1,int y1,int x2,int y2,int c)
{
   SRGP_setColor(c);
   SRGP_lineCoord(x1,599-y1,x2,599-y2);
}

void draw_bar(int x1,int y1,int x2,int y2,int c)
{
   SRGP_setColor(c);
   SRGP_fillRectangleCoord(x1,599-y2,x2,599-y1);
}

void draw_setpalette(int n,int r,int g,int b)
{
   SRGP_loadSingleColor(n,r*1024,g*1024,b*1024);
}

void draw_setallpalette(unsigned char *p)
{
   int i;
   unsigned short r[256],g[256],b[256];
   for(i=0;i<_draw_colors;i++)
   {
      r[i]=*(p++)<<8;
      g[i]=*(p++)<<8;
      b[i]=*(p++)<<8;
   }
   SRGP_loadColorTable(0,_draw_colors,r,g,b);
}

void draw_putpixel(int x,int y,int c)
{
   SRGP_setColor(c);
   SRGP_pointCoord(x,599-y);
}

int draw_getpixel(int x,int y)
{
   /* Not supported */
   return 0;
}

int draw_getch(void)
{
   char buffer[2];
   buffer[0]=0;
   while(SRGP_waitEvent(0)!=KEYBOARD);
   SRGP_getKeyboard(buffer,2);
   return buffer[0];
}

int draw_getkey(void)
{
   char buffer[2];
   buffer[0]=0;
   if(SRGP_waitEvent(0)==KEYBOARD)
      SRGP_getKeyboard(buffer,2);
   return buffer[0];
}
