!	CVIMG -- Convert Oxygene X.OUT files to image files.
!	Copyright (C) 1998,2000 Nils M Holm
!	See the file LICENSE for conditions of use.

#r5;

interface	readpacked(3) = 11,
		writepacked(3);


const	EXECMAGIC_HI=	6514,
	EXECMAGIC_LO=	1060;

const	XHMAGIC = 0, XLMAGIC = 1, XFLAGS = 2, XLTEXT = 3, XLDATA = 4,
	XLBSS = 5, XLSYM = 6, XHDR = 8;


error(m) do
	select(1, 2);
	writes("CVIMG: ");
	writes(m);
	newline();
	halt;
end


do
	var	hdr[XHDR];
	var	buffer::1024;
	var	k, k2, len;

	k := readpacked(0, hdr, XHDR*2);
	if (hdr::(XLMAGIC*2+1)<<8|hdr::(XLMAGIC*2) \= EXECMAGIC_LO)
		error("magic match failed");
	if (hdr::(XHMAGIC*2+1)<<8|hdr::(XHMAGIC*2) \= EXECMAGIC_HI)
		error("magic match failed");
	if (	hdr::(XLDATA*2+1)<<8|hdr::(XLDATA*2) \= 0 \/
		hdr::(XLBSS*2+1)<<8|hdr::(XLBSS*2) \= 0
	)
		error("input is not a pure TEXT file");
	len := hdr::(XLTEXT*2+1)<<8 | hdr::(XLTEXT*2);
	while (len) do
		k := len > 1024-> 1024 : len;
		k2 := readpacked(0, buffer, k);
		if (k \= k2) error("file read error");
		if (writepacked(1, buffer, k) \= k)
			error("file write error");
		len := len-k;
	end
end

