#!/bin/sh

LIBC=/usr/lib/libc.a
OUTFILE=""
LIB=../native/libtx.a
MACHINE=386

while true; do
	case $1 in
	-o)
		OUTFILE=$2
		shift; shift ;;
	*)
		break;;
	esac
done

if [ x$1 = x -o x$2 != x ]; then
	echo TXBOOT: syntax error
	exit 1
fi

if [ x$OUTFILE = x ]; then
	OUTFILE=`basename $1 .t`
	if [ $OUTFILE = $1 ]; then
		echo "TXBOOT: input program has no .t suffix"
		exit 1
	fi
fi

../compiler/txtrn <$1 >$OUTFILE.UNOPT
../compiler/txopt <$OUTFILE.UNOPT >$OUTFILE.tcode
rm -f $OUTFILE.UNOPT

../native/txcg$MACHINE.boot <$OUTFILE.tcode >$OUTFILE.s
rm $OUTFILE.tcode

as -o $OUTFILE.o $OUTFILE.s
if [ $? != 0 ]; then
	exit 1
fi
rm $OUTFILE.s

ld -o $OUTFILE $OUTFILE.o $LIB $LIBC
rm $OUTFILE.o
if [ $? != 0 ]; then
	exit 1
fi
strip $OUTFILE

