#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include "file.h"

int file_open(char *pn)
{
  union REGS inregs, outregs;
  struct SREGS segregs;

  inregs.h.ah = 0x3d;           /* open a file */
  inregs.h.al = READ_ONLY;
  segregs.ds = FP_SEG(pn);
  inregs.x.dx = FP_OFF(pn);

  return intdosx(&inregs, &outregs, &segregs);
}

int file_close(int fd)
{
  union REGS inregs, outregs;

  inregs.h.ah = 0x3e;           /* close a file handle */
  inregs.x.bx = fd;

  return intdos(&inregs, &outregs);
}

int rdbin(int fd, char *buf, int count)
{
  union REGS inregs, outregs;
  struct SREGS segregs;
  int bytes_read;

  inregs.h.ah = 0x3f;         /* read from file or device, using handle */
  inregs.x.bx = fd;
  inregs.x.cx = count;
  segregs.ds = FP_SEG(buf);
  inregs.x.dx = FP_OFF(buf);

  bytes_read = intdosx(&inregs, &outregs, &segregs);
  if (outregs.x.cflag)
    bytes_read = 0;

  return bytes_read;
}

int get_curr_dir(int drive, char *dir)
{
  union REGS inregs, outregs;
  struct SREGS segregs;

  inregs.h.ah = 0x47;
  inregs.h.dl = drive;
  inregs.x.si = FP_OFF(dir);
  segregs.ds = FP_SEG(dir);

  return intdosx(&inregs, &outregs, &segregs);
}

void get_path(char *s)
{
  int i, stop, drive;
  char dir[MAXDIR];

  i = strlen(s);
  do {
    stop = s[--i] == ':' || s[i] == '\\';
    if (!stop)
      s[i] = '\0';
  } while (i > 0 && !stop);
  if (strchr(s, ':') == NULL) {
    strins(s, " :", 0);
    s[0] = getdisk() + 'A';
  }
  if (s[2] != '\\') {
    drive = s[0] - 'A' + 1;
    get_curr_dir(drive, dir);
    if (dir[0] != 0)
      strcat(dir, "\\");
    strins(s, dir, 2);
    strins(s, "\\", 2);
  }
}
