          CUMULATIVE SELECTION AS A MULTI-DISCIPLINE META-THEORY:
                    AN ANALYSIS AND COMPUTER SIMULATION
                          Michael E. Mills, Ph.D.
                           Psychology Department
                        Loyola Marymount University
                           Los Angeles, CA 90045

 Copyright (c) 1991 Michael E. Mills, Ph.D.

 You are about to witness a computer simulation of  a  very  powerful  and
 extremely important process: cumulative selection. Other than creation by
 an intelligent being, it is the  only  known  natural  process  that  can
 produce highly organized complexity from an initial state of disorder and
 randomness.  Amazingly, this complex organization is built  up  gradually
 and  blindly.   It  is  the  moving  force  that shapes and increases the
 evolution of complexity of biological, behavioral and cultural phenomena.
      In  this  tutorial  and  computer  demonstration  the   process   of
 cumulative  selection  will  be  defined  and  described. It will then be
 compared with a process with which it has  been  often  confused:  single
 step selection.
      The differences between single step  and  cumulative  selection  are
 unclear  to  many  people.   However, the differences are truly profound.
 Single step selection does not have the  capacity  to  produce  organized
 complexity; only cumulative selection does.
      Finally, we will  discuss  how  cumulative  selection  represents  a
 fundamental "meta-theory" that transcends traditional academic discipline
 boundaries. Via analogies, we'll see cumulative  selection  operating  in
 biological  evolution,  behavioral  learning, the formulation of cultural
 practices, scientific research, and even in the development of  your  own
 ideas.

 THE GENESIS OF COMPLEXITY IN AN ENTROPYING UNIVERSE
      Physicists  tell  us  that,  taken  as  a  whole,  the  universe  is
 continuously  and  inexorably losing information and complexity.  This is
 the second law  of  thermodynamics--a  process  called  'entropy.'   This
 continually  increasing  disorder  started  moments  after 'big bang,' it
 continues to this day, and it will continue  into  the  future.  The  end
 result  will  be  a  universe that is almost completely void of order and
 organization.  Molecules will no longer exist and even  atoms  will  have
 broken  down into elementary particles and radiation--all complexity will
 have been dissolved.
      Fortunately for us, there is a counter-force to entropy also at work
 in  the  universe.  Against this general backdrop of increasing disorder,
 in perhaps a few extremely isolated corners in the universe (such as  the
 Earth),   exist  biological  and  cultural  systems  that  are  gradually
 increasing in complexity and organization.
      This would appear to violate the second law of  thermodynamics.   In
 fact  it  does  not.  By "extracting" order from the universe, cumulative
 selection actually  increases  the  overall  amount  of  entropy  in  the
 universe  as  a whole.  This is because cumulative selection is a process
 that requires either an internal (biological) or external (environmental)
 energy source for it to operate.
     For example, let's say that you will expend 200 calories  to  analyze
 and  store information the information presented in this tutorial in your
 brain. After this tutorial, presumably your brain  will  have  become  an
 even more highly ordered system--a reverse entropy process. To accomplish
 this, you will have had to convert a form of highly ordered energy (food)
 into  very  disordered  energy  (heat).  The resulting increased order of
 your brain will have decreased the order in the food by a  factor  of  10
 million  million million times the amount of the increase of the order of
 your brain. By thinking about and  memorizing  the  information  in  this
 tutorial, you are actually accelerating entropy!
     But don't worry--there is a great deal of ordered energy left in  the
 universe!  We won't run out for many billions of years (Hawking, 1988).

 A DEMONSTRATION OF SINGLE-STEP SELECTION
      For this exercise, please close both of your hands into a fist, with
 the  exception of your two index fingers, which are to be fully extended.
 Now, position your two hands over the keyboard before you.   In a moment,
 I  would  like you to close your eyes and randomly type out 28 letters on
 the  keyboard.   You  will  alternate  tapping  with  each  finger,   and
 reposition   each   finger  "randomly"  each  time.   The  computer  will
 acknowledge each letter you type in with a short "beep." After  you  have
 typed in 28 letters, I'll notify you with 3 rapid beeps on the computer's
 speaker, at which time you can open your eyes again!  Ready?  As soon  as
 you press return, start tapping out 28 letters, one letter at a time.

 @    THE TYPING 28 LETTERS RANDOMLY DEMO IS HERE.

 Answer: The number of attempts, or "generations,"  required  to  randomly
 type the sentence 'methinks it is like a weasel' is very large.  In fact,
 it is  unthinkably  large.   You  could  spend  the  rest  of  your  life
 repeatedly  typing  random  series  of  28  letters and never produce the
 sentence 'methinks it is like a weasel.'
     Exactly what are the odds?   Let's  calculate  them.  The  chance  of
 getting  the first letter, 'm', correct is 1 in 27 (the 26 letters of the
 alphabet plus the 'space' character).   We have the same 1 in  27  chance
 of  getting  any  of  the other letters in the correct position.  But the
 chance of getting all the letters in the correct position,  at  the  same
 time,  in  one try, is the probability of getting any one character (1 in
 27) multiplied by the total  number  of  letters  in  the  sentence  (28,
 including  the  spaces).   Twenty seven to the 28th power is a very large
 number.  You have about  1  chance  in  10,000  million  million  million
 million  million million of getting the entire phrase correct in one try.
 How long do you think it would it take a monkey  randomly  pecking  at  a
 typewriter to produce the entire works of Shakespeare?
     First we need to know how many letters  there  are  in  the  complete
 works  of  Shakespeare.  Well, on second thought, perhaps we'll save that
 exercise for another day.

     The exercise you just performed is  an  example  of  what  is  called
 "single  step  selection"--the probability of getting a series of letters
 (or genes, or behaviors, or scientific ideas, or lottery  numbers,  etc.)
 correct  in  one  random try. As you can see, the probably of single step
 selection producing anything interesting, such as a meaningful  sentence,
 is  pretty  close to nil.  The probability of it producing anything truly
 complex, such as a living organism, is, to a mere mortal, as close to nil
 as you can get.

      The  reason  that  single  step  selection  performs  so  poorly  in
 producing  complex  things  is  that  no  information  is  passed between
 generations. Without surviving information, each  generational  "attempt"
 must start again entirely from scratch, without any "assistance" provided
 by ancestors.

 CUMULATIVE SELECTION
     In contrast, cumulative  selection  "breeds"  the  next  generation--
 information  developed  so  far  about  the  "solution" to the problem is
 passed on to the next generation.   The "problem" may be how to  guess  a
 sentence  that I am thinking,  or it may be how a biological organism can
 adapt to an environment.  The problem may also be to learn how to  behave
 in  a  way  that  will  help you obtain what you find rewarding and avoid
 stimuli that are punishing.
     The next computer simulation is truly dramatic--because you will  see
 actual  cumulative  selection  in the process of producing complexity (in
 this case, cumulative selection will, by itself,  produce  the  sentence:
 'methinks it is like a weasel').  The computer will repeatedly generate a
 random series of 27 letters.  When a randomly generated letter happens to
 be the correct letter in the correct position (given our target sentence)
 it then is "selected"  and  passed  on  to  the  next  generation.   This
 successive  inheritance  of "correct" letters will eventually produce the
 target sentence.
      While cumulative selection is progressively "finding  the  solution"
 to  this  problem  by  repeated  breeding,  you will see that single step
 selection is performing very poorly in comparison.

     Keep in mind that the computer is not preprogrammed  to  produce  the
 target  sentence after a certain number of generations. Rather, with each
 new generation, cumulative selection must work with the "raw material" of
 each  random  series  of  27  letters  that are fed to it. It may take 20
 generations or 220 generations before it the  sentence  'methinks  it  is
 like  a  weasel' is produced--there is simply no way to predict.  So what
 you are about to see is actual cumulative selection in progress. This  is
 not just a simulation of cumulative selection, it is a real demonstration
 of cumulative selection in action.


 @ THE WEASEL2 (RAPID GENERATIONS) IS HERE


     Wow!  Pretty fast!

     How did cumulative selection do it?
     There  are  two  essential  processes  that  we  need  understand  to
 comprehend   how   cumulative   selection  operates:   "replicators"  (or
 "repeators") and "sieving" (or "selection").

  "REPEATORS" AND "REPLICATORS"
      In the last demonstration, you noted that  a  number  of  successive
 attempts, or "generations," were required to produce the target sentence.
 Repeating a "sieving" process over and over many times is a  prerequisite
 for  the  occurrence of cumulative selection.  Each successive generation
 "breeds" the next generation, and that subsequent  generation  "inherits"
 the results of the previous breeding.
      The repetitions that are required for cumulative selection to  occur
 in  the  biological  world  are  performed  by  "replicators."  These are
 molecules that have the ability to replicate themselves, such as DNA.
      Cumulative selection can also operate in  the  nonbiological  world,
 via  a what might be termed a "repeator" process.  For example,  as noted
 by Dawkins (1986), if you walk along a pebbly beach, you may notice  that
 the  pebbles  and  rocks are not randomly distributed.  Rather, the rocks
 are often clearly sorted into various lanes or rows.  As  you  walk  from
 the  berm to the water, you often walk over several zones of rocks.  Each
 zone is characterized by rocks of  a  particular  size.   The  "repeator"
 process in this case has been the repeated action of the waves and tides.
 The "sieving" or "selection" process has been the amount  of  force  that
 the  waves apply to each rock.  Pebbles and rocks have been selected into
 zones according to their size and weight.

 @    Show the illustration of the rock sieves

 SIEVING AND SELECTION
      We can of think another situation wherein rocks  can  be  sorted  by
 size  via  a cumulative selection process.  Imagine that we have a series
 of 10 sieves, stacked  one  on  top  of  the  other.   They  are  stacked
 according  to how fine each sieve is. Let's say that the sieve at the top
 will catch rocks a foot across  or  wider;  anything  smaller  will  pass
 through  it to the sieve below. The second sieve, a foot below the first,
 is a slightly finer sieve, and so on.  The middle sieve might be a  chain
 link fence; at the bottom the final sieve is a window screen.
      We now put several shovel fulls of sand, gravel  and  rocks  into  a
 wheelbarrow,  and  mix  it  up thoroughly.  Imagine that we then dump the
 contents of the wheelbarrow on the top sieve. What will happen?  We  will
 see order quickly emerge from disorder as the rocks, gravel and sand drop
 down through the series of sieves.
      When the dust settles, the rocks and gravel will be neatly sorted by
 size.  The top sieve will have caught the largest rocks, the second sieve
 the next largest rocks, and so on.  Each level  will  have  a  particular
 size of rock or gravel. Order is derived from disorder.
      Observing cumulative selection produce a target sentence by  feeding
 in  random  letters  generated by a computer is interesting.  But how can
 cumulative  selection  produce  such  immensely  complex   phenomena   as
 organisms,  behavior,  and  culture   while operating without a goal, and
 without intelligence?


 @    Show gene sieves in the bottom window.

    Read the screen in the bottom window, then continue reading here.

 BIOLOGICAL EVOLUTION

     In biological evolution, each generation represents a sieve. What  is
 being  sieved  are  not rocks, but genes.  The siever is not a chain link
 fence, but "fitness" (reproductive  success).   Genes  that  promote  the
 fitness  of  an  individual  make  it  through  the generational sieve of
 biological evolution to the next generation.  Genes that do  not  promote
 reproductive  success  of an organism are left behind.  In the gene pool,
 genes that do a better job of  increasing  the  reproductive  success  of
 their particular organism will come to dominate, while the less effective
 genes are left behind in the "genetic dump heap."

      By analogy with our rock and gravel siever, imagine that  over  time
 unfit  genes  swell  up  and get larger.  Of course, this really does not
 happen, but this visual analogy will help illustrate the process of  gene
 selection.   These  "large,"  unfit  genes  won't  make it down very many
 generational sieves.

 A little earlier, we  saw  that  cumulative  selection  could  relatively
 quickly  produce  order  out of randomness. Let's look at this again, but
 this time we will slow things down a bit, so that we can see more clearly
 what is happening.


 @  CUMULATIVE SELECTION SLOW DEMO (@ must follow each screen)



 @
 In the window below, we will compare cumulative and single step selection
 generation by generation.  Here is what each of the headings mean:
 CUMULATIVE SELECTION:
  Random Mutation--> this is a computer generated series of
         random letters "fed" to this generation.
  Current (Bred) Generation-->  the current, "descendant"  generation
         produced so far by the process of cumulative selection.

 @
 SINGLE-STEP SELECTION:
  Current (Random) Mutation--> this is a computer generated series
   of letters "fed" to this generation of single step selection.
   Remember, single step selection does not "inherit" any of the
   correct letters from previous generations.
  Best approximation so far--> although single step selection
   does not retain its closest approximation to the target, we'll
   save the best approximation here just for comparison.

 @

 @
 CUMULATIVE SELECTION IN BIOLOGICAL EVOLUTION

 To understand how cumulative selection operates in biological  evolution,
 imagine  that  a series of randomly generated letters represent a genetic
 code.  For our demonstration, let's say that most any  randomly  produced
 series  of 28 letters actually do produce a viable organism of some type.
 However, although viable,  such organisms are far from  well  adapted  to
 their environment.

 @
 In fact, they may die out relatively soon if the environment  changes  or
 they  meet  some  hardship.   In  order  to  be  "best"  adapted  to this
 hypothetical environment, an organism must have a genetic code that (just
 happens!) to spell out the sentence:
     "methinks it is like a weasel"

 @

 @
 By imagining that  the  randomly  generated  letters  below  represent  a
 genetic code, we can see how, every so often, that genetic code is slowly
 improving to produce an organism  progressively  better  adapted  to  its
 environment.

 @
 The random fluctuations in the letters each generation represent  genetic
 mutations.   As  you can see, the vast majority of these mutations do not
 improve the fitness (reproductive success) of the organism.   These  non-
 adaptive  genetic  mutations do not make it to the next generation.  They
 are discarded.   They may have helped some other organism in a  different
 environment, but not this one.

 @
 The "sieve" in this process of biological evolution is natural selection.
 Genes  that  make  it through the generational sieve of natural selection
 are genes that improve the reproductive success of  its  host  "vehicle."
 Organisms  are  vehicles  for  genes in the sense that they are temporary
 "throw away" shells for them.   Organisms protect genes  from  a  hostile
 environment,   and  from  other  organismic vehicles created by competing
 genes.  (By the way, these competing organisms can  indeed  compete  very
 nastily--some  have  evolved  elaborate fighting weapons, such as incisor
 teeth and claws.)

 @

 @
 The primary "task" of organisms, and  the  biological  reason  for  their
 existence,   is  to  copy  genes.   Of  course,  genes  don't  "want"  to
 reproduce--the process of natural selection simply makes it  appear  that
 way  since  only  those  genes  that promote reproductive success in fact
 survive.  And, as they say, nothing succeeds like success!

 @
 What is cumulative selection accumulating?  Information!  DNA is simply a
 repository  of  information, developed over an unthinkingably long period
 of time (about 3 to 4 billion years), about how to  produce  an  organism
 that can facilitate survival and reproduction in a sometimes changing and
 progressively more competitive environment.

 @
 CUMULATIVE SELECTION IN BEHAVIORAL LEARNING.

 We can  also  see  cumulative  selection  operating  in  the  ontogenetic
 (individual)  behavioral  development  of  an organism. To understand how
 cumulative selection operates in behavioral evolution, imagine that  each
 of  the  randomly  generated  letters represents a behavior.  Suppose you
 worked as a dolphin trainer at Sea World. A new, untrained dolphin  might
 display a variety of "random" behaviors. Your task, as the trainer, is to
 wait for the behavior you want repeated to appear.   When  it  does,  you
 reward the dolphin with a fish.

 @

 @
 Rewarded behavior is more likely to appear again.   You  are  "selecting"
 the  behavior of the dolphin through contingent positive reinforcement. A
 behavioral trainer in this sense might be called a "Behavioral  Selector"
 or  "Behavioral Siever."   Suppose  you wanted the dolphin to swim around
 the tank, jump through a hoop, and fetch a life ring.  Let's say that the
 letter  'm'  represents  the  behavior  of  swimming around the tank in a
 particular direction.

 @
 You guessed, it: the letter 'e' represents jumping through a hoop, and so
 on.   We  can  imagine  that  the sentence 'methinks it is like a weasel'
 represents a chained series of discrete behaviors. The "repeator" process
 in  this case are the number of learning trials (analogous to generations
 in  biological  evolution).   Analogous  to   reproductive   success   is
 behavioral  success  (getting  the  fish  for  a  correct, or 'adaptive,'
 behavior).  As the trainer, you are like Mother Nature! You are doing the
 selecting!

 @
 In this  process  of  cumulative  behavioral  evolution,  what  is  being
 accumulated?  Again, it is information.  The information this time is not
 about how to produce a biological vehicle well adapted  to  a  particular
 environment;  rather it is how to behaviorally adapt to an environment to
 obtain positive reinforcement.  The  repository  of  information  is  not
 DNA--it  is in the neurons of the dolphin's brain.  The cumulative memory
 of positive reinforcement (and punishment)  is  basically  what  we  call
 learning.

 @
 There  is  an  interesting  parallel  between  biological  evolution  and
 behavioral  evolution.    Life  (reproductive  success)  and death are to
 biological  evolution  what   positive   reinforcement   (pleasure)   and
 punishment  (pain)  are  to  behavioral  evolution.   Both  are part of a
 "sieving" process.  Life and death sieve genes; pleasure and  pain  sieve
 behaviors.   Both  add  to a store of information about how to adapt to a
 particular environment, either  biologically  in  phylogenetic  (species)
 time, or behaviorally in ontogenetic (an individual's life) time.

 @
 We can use  an  analogy  to  help  understand  the  relationship  between
 phylogenetic  and  ontogenetic adaption.  A sensitive radio, telescope or
 microscope may have separate controls for 'gross' and 'fine' tuning.   We
 can  think of the phylogenetic evolution of behavioral predispositions as
 analogous to a  "gross-tuning"  device,  and  the  learning  of  specific
 behaviors  by  a  particular  individual  during his or her lifetime as a
 "fine-tuning" device.
      For example, the biological predisposition humans have  to  learn  a
 language  was  produced  by  successive  sieving of genes in phylogenetic
 time. However, the specific language(s) that an individual learns  during
 his  or her lifetime is the result of the successive sieving of behaviors
 in  ontogenetic  time.  Phylogenetic   "gross   tuning"   of   behavioral
 predispositions  and  instincts  help  a species to adapt to a particular
 ecological niche.  Ontological "fine tuning" of these behaviors  via  the
 sieving  process  of learning further helps an individual to adapt to the
 demands of his or  her  specific  physical,  interpersonal  and  cultural
 environment.   Additional  ontogenetic  "fine tuning" of these behavioral
 predispositions

 @
 LANGUAGE: THE GENESIS OF CULTURE
     Many researchers suggest  that  perhaps  the  only  really  important
 distinction  between  humans  and the higher primates is that humans have
 the ability to  communicate  symbolically  via  a  spoken  (and  written)
 language.  The evolution of language is an evolutionary quantum leap. The
 reason that language, particularly written language, is so  important  is
 that  it allows for something entirely new to be sieved over generations:
 ideas.  The cumulative  selection  of  ideas  over  generations  produces
 culture.
      Humans without language or culture  are  indeed  "barbaric  savages"
 and  behave  not  too  unlike  other primates.  Imagine a group of modern
 humans that had somehow been stripped of their language and culture,  and
 were  placed  on  a remote island, totally isolated from civilization. It
 would  take  many  generations  for  "higher"  human  characteristics  to
 reappear.    These "higher" human characteristics of language and culture
 would appear very gradually, via a long process  of  cultural  cumulative
 selection.
      To bring home this point, look around you.  The computer you are now
 using,  the car you drive, the stereo you listen to -- did you invent any
 of these things?  Of course not.  The vast majority of what you know, and
 the technology you use, you did not discover.   Good ideas and inventions
 were handed  down  to  you  by  previous  generations--a  result  of  the
 cumulative  selection  of  ideas.   You just happen to be one of the very
 lucky few to have been born fairly recently  to  take  advantage  of  the
 cumulative selection of these ideas.  We owe a heavy debt of gratitude to
 the good ideas of many dead people that have been handed  (or,  "seived")
 down to us.

 @
 CUMULATIVE SELECTION IN SCIENCE

 Science, in particular, relies  on  cumulative  selection.   Without  it,
 scientific progress would come to a halt.  Both science and evolution: a)
 perform experiments, and b) pass the results of those experiments  on  to
 succeeding  generations  in  an  ever  accumulating fashion. For example,
 scientists  perform  experiments  and  communicate  their  findings  (via
 journal  articles  and  books)  to  the  next generation of scientists to
 inherit and build on.
     In fact, the scientific method is simply a  recipe  for  accelerating
 the cumulative selection of ideas of a culture.

 @
 Ideas and theories that  do  not  explain  observed  phenomena  well  are
 discarded.  "Mutant"  theories  are  developed,  a  few  of which will be
 "adaptive" (explain  the  data  more  parsimoniously).  Those  ideas  and
 theories  are  retained.   Both  evolution  and  science are the ultimate
 pragmatists: they only keep "what works" and pass that information on  as
 the starting point for the next generation.

 @
 IS A LOTTERY CUMULATIVE SELECTION OR SINGLE STEP SELECTION?

 To play the California State Lottery "6-49" game you select  six  numbers
 (each  of  which  may  range  from  1 - 49).  To win, the six numbers you
 select must match the six  numbers  randomly  generated  by  the  lottery
 machine.   What is the probability that you would correctly guess all six
 numbers? Unlike our 'methinks it is like a weasel" example, at least  the
 six numbers don't have to be in a particular order--they must only be the
 correct six numbers.

 @
 Even so, the odds of winning are astronomical.  But suppose that the same
 set  of winning numbers was retained from week to week.  And suppose that
 each week you were allowed to keep any "correct" number you had  selected
 that  week  for the next drawing.   For example, if this week you got one
 number correct, you could keep it for next week and select  only  5  more
 numbers (since you already have one correct).

 @
 How long would it take before you got all six numbers correct?  Not long.
 Now you know why a lottery is a always single step selection.

 (But if you know of lottery that allows for the cumulative  selection  of
 numbers, please let me know!)

 @
 Let's watch the process of cumulative  selection  occur  below.   (If  it
 continues too long and you would like to exit, press Cntrl-C.)

