
/*
	XMS.HPP
	Created 1995 by Dejvid Zaninovic
*/

#ifndef XMS_HPP
#define XMS_HPP

#include "c.hpp"

#define XE_NOERR	0x00	// no error
#define XE_NODRVR	0x01	// no XMS driver
#define XE_FUNC 	0x80	// function is not implemented
#define XE_VDISK    0x81	// VDISK device is detected
#define XE_A20		0x82	// A20 error
#define XE_GEN		0x8e	// general driver error
#define XE_UNREC	0x8f	// unrecoverable driver error
#define XE_NOHMA	0x90	// HMA does not exist
#define XE_HMAINUSE	0x91	// HMA is already in use
#define XE_HMAMIN	0x92	// DX is less than /HMAMIN= parameter
#define XE_HMAFREE	0x93	// HMA is not allocated
#define XE_A20E		0x94	// A20 line is still enabled
#define XE_EXALOC	0xa0	// all XMS is allocated
#define XE_NOHANDLE	0xa1	// all available XMS handles are in use
#define XE_HANDLE	0xa2	// handle is invalid
#define XE_SHANDLE	0xa3	// source handle is invalid
#define XE_SOFF		0xa4	// source offset is invalid
#define XE_DHANDLE	0xa5	// destination handle is invalid
#define XE_DOFF		0xa6	// destination offset is invalid
#define XE_LEN		0xa7	// length is invalid
#define XE_MOVE		0xa8	// move has an invalid overlap
#define XE_PARITY	0xa9	// parity error occurs
#define XE_NOTLOCK	0xaa	// block is not locked
#define XE_LOCK		0xab	// block is locked
#define XE_COUNT	0xac	// block's lock count overflows
#define XE_LFAILS	0xad	// lock fails
#define XE_SMUMB	0xb0	// smaller UMB is available
#define XE_NOUMB	0xb1	// no UMBs are available
#define XE_UMBSEG	0xb2	// UMB segment number is invalid

extern void far *xms_driver;				// XMS driver
extern boolean xms_inited;					// XMS is inited
extern byte xms_error;						// vrsta errora

extern "C" boolean xms_init();				// init XMS
extern "C" word xms_version();				// get XMS version 
extern "C" word xms_revision();				// get XMS revision
extern "C" boolean xms_ishma();				// is HMA exist
extern "C" boolean xms_allochma (unsigned n); // alloc HMA
extern "C" boolean xms_freehma();			// free all HMA
extern "C" boolean xms_genable20();			// global enable A20
extern "C" boolean xms_gdisable20();		// global disable A20
extern "C" boolean xms_lenable20();			// local enable A20
extern "C" boolean xms_ldisable20();		// local disable A20
extern "C" boolean xms_query20();			// query A20
extern "C" word xms_totmem();				// query total free XMS 
extern "C" word xms_coreleft();				// query largest free XMS block
extern "C" boolean xms_alloc (word size, word far *handle);	// alloc XMS
extern "C" boolean xms_free (word handle);	// free EMB
extern "C" boolean xms_copy (dword len, word shandle, dword soff,
	word dhandle, dword doff);				// copy mem
extern "C" void far *xms_lock (word handle);// lock EMB, get absolute adr
extern "C" boolean xms_unlock (word handle);// unlock EMB
extern "C" int xms_locks();					// get num of locks
extern "C" int xms_freehandles();			// get num of free handles
extern "C" word xms_getlen (word handle);	// get len of EMB
extern "C" boolean xms_realloc (word size, word handle); // re alloc EMB
extern "C" void far *xms_allocumb (word n);	// alloc UMB
extern "C" boolean xms_freeumb (void far *mem);	// free UMB

#endif
