
/*
	TIME.HPP
	Created 1995 by Dejvid Zaninovic
*/

#ifndef TIME_HPP
#define TIME_HPP

#include <dos.h>
#include "c.hpp"

boolean istime (byte hour, byte minute, double second); // is time ok

class xtime {
	volatile byte day;              		// days
	volatile byte hour;						// hours
	volatile byte minute;					// minutes
	volatile byte second;					// seconds
	volatile long ms;						// microseconds
	static void interrupt (*old08)();		// old int 8
	static void interrupt new08();			// new int 8
	static void interrupt (*old70)();		// old int 70
	static void interrupt new70();			// new int 70
	static struct stimer {
		xtime *p;							// pointer on class
		boolean high;						// is high resolution timer
		stimer *next;						// next stimer struct
	} *timer;						
	dword addms (dword nms);				// add ms without floating point
public:
	xtime();								// init time to 00:00:00
	xtime (byte hour, byte minute=0, double second=0, byte day=0); // init all
	~xtime();								// deinstall all
	byte getday() const {return day;};		// return day
	byte gethour() const {return hour;};	// return year
	byte getminute() const {return minute;};// return month
	double getsecond() const;				// return second
	byte setday (byte n) {return day=n;};	// set day, return day
    byte sethour (byte n);                  // set hour, return hour
	byte setminute (byte n);				// set minute, return minute
	double setsecond (double n); 			// set second, return second
	boolean set (byte hour=0, byte minute=0, double second=0, // set all
		byte day=0); 
	boolean istime() const {                // is time ok
		return ::istime (hour, minute, second);
	}
	double tton() const;					// return numeric from time
	xtime ntot (double n);					// set time from numeric
	friend xtime now();						// get present time
	xtime now();							// set time to now
	xtime operator + (double n); 			// add seconds to time
	xtime operator - (double n); 			// sub seconds from time
	long operator - (xtime t); 				// sub time from time
	boolean operator > (xtime t) const;		// compare times
	boolean operator < (xtime t) const;		// compare times
	boolean operator >= (xtime t) const;	// compare times
	boolean operator <= (xtime t) const;	// compare times
	boolean operator == (xtime t) const;	// compare times
	boolean operator != (xtime t) const;	// compare times
	boolean start (boolean high = FALSE);	// start timer
	boolean stop();							// stop timer
};

#endif

