/**********************************************************/
/* File Id.                  Scroll.C                     */
/* Author.                   Stan Milam.                  */
/* Date Started.             05/23/89.                    */
/*                                                        */
/*           (c) Copyright 1989-90 by Stan Milam          */
/*                                                        */
/* Purpose: To scroll a text window anywhere on the screen*/
/* without causing flicker on the CGA and to do it very   */
/* very fast on MDA, EGA, and VGA.  Can scroll the window */
/* up or down.                                            */
/**********************************************************/

#include <stdio.h>
#include <dos.h>
#include "pcwproto.h"
#include "pcw.i"

int scroll(int ur,int uc,int lr,int lc,int fg,int bg,int count) {

   int far *source, far *dest, far *line;
   int rows, cols, page, pagesize;
   int cl, rw, attr, dir;
   unsigned offset, scrnseg;

   if (!chk_video_state(&rw, &cl)) return(0);    /* Not a valid text mode */
   if (count == 0) return(1);                    /* Fake good return */
   if (count > 0) dir = DOWN;
   else {
     dir = UP;
     count = -count;
   }

   if (lc > cl) {
      cl = lc - cl;                              /* Adjust cooridnates */
      lc = lc - cl;
      uc = uc - cl;
   }
   if (uc < 1) return(0);                        /* Could not adjust */

   if (lr > rw) {                                /* Adjust y coords */
      rw -= lr;
      lr -= rw;
      ur -= rw;
   }
   if (ur < 1) return(0);                        /* Could not adjust */

   rows = (lr - ur) + 1;                         /* Compute total rows */
   cols = (lc - uc) + 1;                         /* And columns */
   pagesize = getpagesize();                     /* Get regen length */
   scrnseg  = getscrnseg();                      /* Get video segment */
   page     = getpage();                         /* Video Page we're using */

   if (dir) {                                   /* Going up */
      offset = MK_SCRNOFF(ur+1,uc);             /* offset of source*/
      source = (int far *)MK_FP(scrnseg,offset);/* Make source pointer */
      offset = MK_SCRNOFF(ur, uc);              /* Offset of destination */
      dest   = (int far *)MK_FP(scrnseg,offset);/* Make destination pointer */
      cl     = lr;                              /* Row to clear */
   }
   else {                                       /* Going down */
      offset = MK_SCRNOFF(lr-1,uc);             /* Make source offset */
      source = (int far *)MK_FP(scrnseg,offset);/* Make source pointer */
      offset = MK_SCRNOFF(lr,uc);               /* Make destination offset */
      dest   = (int far *)MK_FP(scrnseg,offset);/* Make destination pointer */
      cl     = ur;                              /* Row to clear */
   }

   offset = MK_SCRNOFF(cl,uc);                  /* Offset of line to clear */
   attr   = MK_ATTR(fg,bg) | 32;                /* Char & attr of line */
   line   = (int far *)MK_FP(scrnseg,offset);   /* Make the pointer */
   do {                                         /* Repeat until done */
     Tscroll(source,dest,rows-1,cols,dir);      /* Call Assembler routine */
     Thorzchar(cols,attr,line);                 /* Asm routine to clear */
   } while(--count);                            /* Decrement & compare */
   return(1);                                   /* Return good return code */
}
