#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <pcwproto.h>
#include <menu.h>
#include <keys.h>

void help(void) {

   WNDPTR *wnd;
   static char *helpmsg[] = {
      "Use the menu to select which window you want to move around.",
      "Once you have made your selection use the arrow keys to move",
      "the window around the screen or use the mouse to point where",
      "you want to move the window and \"click\" with  the left mouse",
      "key.  To return to the menu use the right Mouse key  or  the",
      "escape key.  This help screen can be invoked from  the  menu",
      "or by using F1 when moving windows around.                  ",
      " ", "Press any key to return",""
   };

   bordercolor(LIGHTBLUE,BLACK);
   titlecolor(WHITE,RED);
   if (mpresent) hide_mouse();
   wnd = wframe(5, 5, 17, 75,YELLOW,BLACK);
   wtitle(wnd, TOP,LEFT," Friendly Help ");
   w_block_write(wnd,2,CENTER,helpmsg);
   keyin();
   wnd = wpop(wnd);
}

void move_window(WNDPTR *window) {

   int  *wnd, wr, wc, key;
   int  row, col, bstatus;

   wnd = (int *) window;
   wr  = wnd[4]; wc = wnd[5];
   for (;;) {
     key = keyin();
     if ( ischar ( key ) ) key = toupper( key );
     switch( key ) {
         case 'H' :
         case F1  : help(); break;
         case ESC : return;
         case UPARROW :
            wr -= 1;
            if (mpresent) hide_mouse();
            wndmove(window,wr,wc);
            if (mpresent) show_mouse();
            wr = wnd[4];
            break;
         case DOWNARROW :
            wr += 1;
            if (mpresent) hide_mouse();
            wndmove(window,wr,wc);
            if (mpresent) show_mouse();
            wr = wnd[4];
            break;
         case LEFTARROW :
            wc -= 1;
            if (mpresent) hide_mouse();
            wndmove(window,wr,wc);
            if (mpresent) show_mouse();
            wc = wnd[5];
            break;
         case RITEARROW :
            wc += 1;
            if (mpresent) hide_mouse();
            wndmove(window,wr,wc);
            if (mpresent) show_mouse();
            wc = wnd[5];
            break;
         case LEFT_MOUSE_KEY :
            get_mpos( &row, &col, &bstatus );
            hide_mouse();
            wndmove(window,row,col);
            wr = wnd[4]; wc = wnd[5];
            show_mouse();
            break;
         case RITE_MOUSE_KEY : return;
         case BOTH_MOUSE_KEY : help();
         default : break;
     }
  }
}

int demo_c(void) {

   WNDPTR *mwnd, *wnd1, *wnd2;
   int    selection, *wnd, wr, wc;

   static PMNUFLDS plist[] = {
          { '1', "1. Move Window One Around"},
          { '2', "2. Move Window Two Around"},
          { '3', "3. Move the Menu Around  "},
          { 'H', "H. Helpful Program Notes "},
          { 'E', "E. End Demonstration.    "},
          { 0, (char *) 0}
   };

   static PMNUTYPE pmenu = {
      NULL,
      1,1,7,31,RED,LIGHTGRAY,
      SINGLESIDES,BLACK,LIGHTGRAY,
      " Moving Window Menu ", TOP, MIDDLE,BLUE,LIGHTGRAY,
      WHITE,BLUE,0,
      plist
   };

   bordercolor(BLACK,LIGHTGRAY);
   titlecolor(RED,LIGHTGRAY);
   if ( mpresent ) hide_mouse();
   wnd1 = wframe(1,33,7,53,BLUE,LIGHTGRAY);
   wtitle(wnd1,TOP,MIDDLE," Window One ");
   wnd2 = wframe(1,55,7,75,RED,LIGHTGRAY);
   titlecolor(BLUE,LIGHTGRAY);
   wtitle(wnd2,TOP,MIDDLE," Window Two ");

   mwnd = makepmenu(&pmenu);
   wnd  = (int *) mwnd;
   if ( mpresent ) show_mouse();
   do {
      if (mpresent) {
         wr = wnd[4]; wc = wnd[5];
         set_mpos(wr + 1, wc + 1);
      }
      selection = pmenuinput(&pmenu);
      switch (selection) {
         case '1' : move_window(wnd1); break;
         case '2' : move_window(wnd2); break;
         case '3' : move_window(mwnd); break;
         case 'H' : help(); break;
         default  : break;
      }
   } while (selection != 'E');
   if ( mpresent ) hide_mouse();
   mwnd = wpop ( mwnd );
   wnd1 = wpop ( wnd1 );
   wnd2 = wpop ( wnd2 );
   if ( mpresent ) show_mouse();
   return(0);
}
