INCLUDE CLIB_16.INC

;strncpy() -- Copy n characters of a  string to another
;char __far * __far strncpy(char __far * const, const char __far * const, const size_t);
;NOTES:
;   if string2 > n, then no terminating '\0' is added to string1

_TEXT SEGMENT
strncpy PROC FAR16 C USES es ds si di,
	    p_str1:FAR16 PTR BYTE, p_str2:FAR16 PTR BYTE, num:WORD

	    lds si,[p_str2]	    ;ds:SI = source
	    les di,[p_str1]	     ;es:DI = destination
	    mov cx, [num]	     ;CX = max length

	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    mov dx, es
	    jmp @@exit
@@cont:

@@loop:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jz @@done
	    jmp	@@loop
@@addnull:
	    ; not part of specs
	    ; add terminating null
	    mov BYTE PTR es:[di], 0
@@done:
	    lds si, [p_str1]
	    mov ax, si
	    mov dx, ds
@@exit:
	    ret
strncpy ENDP
_TEXT ENDS
END
