/* screen layout details
 *
 * it looks better if the fields are drawn in some nice order so it you
 * rearrange the fields, check the menu printing functions.
 */

/* size of screen */
#define	NR	24
#define	NC	80

#define	ASPECT	(4./3.)	/* screen width to height dimensions ratio */

#define	GAP	6	/* gap between field name and value */

#define	COL1		1
#define	COL2		27
#define	COL3		44
#define	COL4		61	/* calendar */

#define	R_PROMPT	1	/* prompt row */
#define	C_PROMPT	COL1

#define	R_NEWCIR	2
#define	C_NEWCIR	((NC-17)/2) /* 17 is length of the message */

#define	R_TOP		3	/* first row of top menu items */

#define	R_TZN	(R_TOP+0)
#define	C_TZN	COL1
#define	R_LT	R_TZN
#define	C_LT	(C_TZN+GAP-2)
#define	R_LD	R_TZN
#define	C_LD	(C_TZN+13)

#define	R_UT	(R_TOP+1)
#define	C_UT	COL1
#define	C_UTV	(C_UT+GAP-2)
#define	R_UD	R_UT
#define	C_UD	(C_UT+13)

#define	R_JD	(R_TOP+2)
#define	C_JD	COL1
#define	C_JDV	(C_JD+GAP+3)

#define	R_LST	(R_TOP)
#define	C_LST	COL2
#define	C_LSTV	(C_LST+GAP)

#define	R_LAT	(R_TOP+0)
#define	C_LAT	COL3
#define	C_LATV	(C_LAT+4)

#define	R_DAWN	(R_TOP+2)
#define	C_DAWN	COL2
#define	C_DAWNV	(C_DAWN+GAP+3)

#define	R_STPSZ	(R_TOP+7)
#define	C_STPSZ	COL2
#define	C_STPSZV (C_STPSZ+GAP-1)

#define	R_HEIGHT (R_TOP+2)
#define	C_HEIGHT COL3
#define	C_HEIGHTV (C_HEIGHT+GAP)

#define	R_PRES	(R_TOP+4)
#define	C_PRES	COL3
#define	C_PRESV	(C_PRES+GAP)

#define	R_WATCH	(R_TOP+3)
#define	C_WATCH	COL1

#define	R_LISTING (R_TOP+4)
#define	C_LISTING COL1
#define	C_LISTINGV (C_LISTING+20)

#define	R_SRCH	(R_TOP+5)
#define	C_SRCH	COL1
#define	C_SRCHV	(C_SRCH+16)

#define	R_PLOT	(R_TOP+6)
#define	C_PLOT	COL1
#define	C_PLOTV (C_PLOT+20)

#define	R_ALTM	(R_TOP+7)
#define	C_ALTM	COL1
#define	C_ALTMV	(C_ALTM+10)

#define	R_TZONE	(R_TOP+5)
#define	C_TZONE	COL3
#define	C_TZONEV (C_TZONE+GAP-1)

#define	R_LONG	(R_TOP+1)
#define	C_LONG	COL3
#define	C_LONGV	(C_LONG+4)

#define	R_DUSK	(R_TOP+3)
#define	C_DUSK	COL2
#define	C_DUSKV	(C_DUSK+GAP+3)

#define	R_NSTEP (R_TOP+6)
#define	C_NSTEP	COL2
#define	C_NSTEPV (C_NSTEP+GAP)

#define	R_TEMP	(R_TOP+3)
#define	C_TEMP	COL3
#define	C_TEMPV	(C_TEMP+GAP)

#define	R_EPOCH		(R_TOP+6)
#define	C_EPOCH		COL3
#define	C_EPOCHV	(C_EPOCH+GAP)

#define	R_PAUSE (R_TOP+7)
#define	C_PAUSE	COL3
#define	C_PAUSEV (C_PAUSE+GAP)

#define	R_MNUDEP	(R_TOP+6)
#define	C_MNUDEP	COL3
#define	C_MNUDEPV	(C_EPOCH+GAP)

#define	R_LON	(R_TOP+4)
#define	C_LON	COL2
#define	C_LONV	(C_LON+GAP+3)

#define	R_CAL	R_TOP
#define	C_CAL   COL4

/* planet rows, for all menus */
#define	R_PLANTAB	(R_TOP+9)
#define	R_SUN		(R_PLANTAB+1)
#define	R_MOON		(R_PLANTAB+2)
#define	R_MERCURY	(R_PLANTAB+3)
#define	R_VENUS		(R_PLANTAB+4)
#define	R_MARS		(R_PLANTAB+5)
#define	R_JUPITER	(R_PLANTAB+6)
#define	R_SATURN	(R_PLANTAB+7)
#define	R_URANUS	(R_PLANTAB+8)
#define	R_NEPTUNE	(R_PLANTAB+9)
#define	R_PLUTO		(R_PLANTAB+10)
#define	R_OBJX		(R_PLANTAB+11)
#define	R_OBJY		(R_PLANTAB+12)

/* menu 1 info table */
#define	C_OBJ		1
#define	C_RA		4
#define	C_DEC		12
#define	C_AZ		19
#define	C_ALT		26
#define	C_HLONG		33
#define	C_HLAT		40
#define	C_EDIST		47
#define C_SDIST 	54
#define	C_ELONG		61
#define	C_SIZE		68
#define	C_MAG		73
#define	C_PHASE		78

/* menu 2 screen items */
#define	C_RISETM	7
#define	C_RISEAZ	18
#define	C_TRANSTM	29
#define	C_TRANSALT	40
#define	C_SETTM		51
#define	C_SETAZ		62
#define	C_TUP		73

/* menu 3 items */
#define	C_SUN		4
#define	C_MOON		10
#define	C_MERCURY	17
#define	C_VENUS		23
#define	C_MARS		30
#define	C_JUPITER	36
#define	C_SATURN	43
#define	C_URANUS	49
#define	C_NEPTUNE	56
#define	C_PLUTO		62
#define	C_OBJX		69
#define	C_OBJY		75

#define	PW	(NC-C_PROMPT+1)	/* total prompt line width */

/* macros to pack a row/col and menu selection flags all into an int.
 * (use this rather than a structure because we can compare them so easily.
 * could use bit fields and a union, but then can't init them or use switch.)
 * bit field defs: [15..14]=menu  [13..12]=flags  [11..7]=row  [6..0]=column.
 * see sel_fld.c.
 * F_MNUX also used in main to manage which bottom menu is up.
 */
#define	F_CHG		(1<<12)	/* field may be picked for changing */
#define	F_PLT		(1<<13)	/* field may be picked for plotting or listng */
#define	F_MMNU		(0<<14)	/* field is on main menu */
#define	F_MNU1		(1<<14)	/* field is on menu 1 */
#define	F_MNU2	 	(2<<14)	/* field is on menu 2 */
#define	F_MNU3		(3<<14)	/* field is on menu 3 */
#define	rcfpack(r,c,f)	((f) | ((r) << 7) | (c))
#define	unpackr(p)	(((p) >> 7) & 0x1f)
#define	unpackc(p)	((p) & 0x7f)
#define	unpackrc(p)	((p) & 0xfff)
#define	tstpackf(p,f)	(((p) & ((f)&0x3000)) && \
		    (((p)&0xc000) == ((f)&0xc000) || ((p)&0xc000) == 0))

/* additions to the planet defines from astro.h.
 * must not conflict, and must fit in range 0..15.
 */
#define	SUN	(PLUTO+1)
#define	MOON	(PLUTO+2)
#define	OBJX	(PLUTO+3)	/* the user-defined object */
#define	OBJY	(PLUTO+4)	/* the user-defined object */
#define	NOBJ	(OBJY+1)	/* total number of objects */

#define	cntrl(x)	((x) & 037)
#define	QUIT		cntrl('d')	/* char to exit program */
#define	HELP		'?'		/* char to give help message */
#define	REDRAW		cntrl('l')	/* char to redraw (like vi) */
#define	VERSION		cntrl('v')	/* char to display version number */
#define	END		'q'		/* char to quit current mode */
