/***********************************************************************
**   JUMPCID.CMD
**
**   For a fully-AUTOMATED install of JumpKey
**      There will be no user interaction if the file is used.
**
**   Version 2.3.0
**
**   Arguments:
**     Target_directory
**   If not specified:
**     Assumed target directory = C:\JUMPKEY
**   Log files are written to the root of drive C:
**
************************************************************************/
parse arg trgdir

srcdir = directory()                      /* Source Directory             */
if "" = trgdir then trgdir = 'C:\JUMPKEY'  /* Target Directory            */

catfile  = srcdir||'\JMP230.ICF'           /* Fully Qualified Catalog File */
rspfile  = srcdir||'\JMP230.RSP'          /* Response File                */

elogfile = 'C:\JMPERR.LOG'                /* Error Log file               */
hlogfile = 'C:\JMPINST.LOG'               /* Install History Log file     */

srctype  = 'DRIVE'                        /* Type of source               */
pkgname  = '"IBM JumpKey/2"'              /* Package Name                 */

'install /x /a:I /c:'catfile' /l1:'elogfile' /l2:'hlogfile' /o:'srctype' /p:'pkgname' /r:'rspfile' /s:'srcdir' /t:'trgdir
return rc
