REM simple statistical analysis program
REM *** set up variables and screen ***
file = 10
SCREEN TEXT FLEXIBLE: WINDOW CURSOR ON
nmaximum = -10000: nminimum = 10000
count = 0: total = 0: total_absolute = 0
CLS
PRINT "Statistical analysis program"
'
REM *** choose file ***
FILES
REPEAT
  INPUT "Type name of file to analyse, followed by ENTER ";filename$
UNTIL FIND$(filename$) <> ""
'
REM *** read and process entries ***
CLS
PRINT "Analysing ";filename$;" - PLEASE WAIT"
PRINT
OPEN #file INPUT filename$
WHILE NOT(EOF(file))
  INPUT #file,number
  GOSUB add_entry
WEND
'
REM *** finish calculations and print results ***
IF count = 0 THEN PRINT filename$;" is empty" ELSE GOSUB show_results
'
REM *** tidy up ***
CLOSE #file
END
'
REM *** SUBROUTINES ***
'
LABEL add_entry
  count = count + 1
  total = total + number
  total_absolute = total_absolute + ABS(number)
  nminimum = MIN(number,nminimum)
  nmaximum = MAX(number,nmaximum)
RETURN
'
LABEL show_results
  average = total_absolute/count
  PRINT "RESULTS FOR FILE ";filename$
  PRINT
  PRINT "Final total:";TAB(40);total
  PRINT "Average absolute value of an entry:";TAB(40);average
  PRINT "Minimum value was:";TAB(40);nminimum
  PRINT "Maximum value was:";TAB(40);nmaximum
RETURN

